/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1299;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import slimeknights.mantle.util.JsonHelper;

public abstract class EntityIngredient
implements Predicate<class_1299<?>> {
    public static final EntityIngredient EMPTY = new SetMatch(Collections.emptySet());

    public abstract Collection<class_1299<?>> getTypes();

    public abstract JsonElement serialize();

    public void write(class_2540 buffer) {
        Collection<class_1299<?>> collection = this.getTypes();
        buffer.method_10804(collection.size());
        for (class_1299<?> type : collection) {
            buffer.method_10804(class_7923.field_41177.method_10206(type));
        }
    }

    public static EntityIngredient of(class_1299<?> type) {
        return new Single(type);
    }

    public static EntityIngredient of(Set<class_1299<?>> set) {
        return new SetMatch(set);
    }

    public static EntityIngredient of(class_1299<?> ... types) {
        return EntityIngredient.of(ImmutableSet.copyOf((Object[])types));
    }

    public static EntityIngredient of(class_6862<class_1299<?>> tag) {
        return new TagMatch(tag);
    }

    public static EntityIngredient of(EntityIngredient ... ingredients) {
        return new Compound(Arrays.asList(ingredients));
    }

    public static EntityIngredient read(class_2540 buffer) {
        int count = buffer.method_10816();
        if (count == 1) {
            return new Single((class_1299)class_7923.field_41177.method_10200(buffer.method_10816()));
        }
        ArrayList<class_1299> list = new ArrayList<class_1299>(count);
        for (int i = 0; i < count; ++i) {
            list.add((class_1299)class_7923.field_41177.method_10200(buffer.method_10816()));
        }
        return new SetMatch((Set<class_1299<?>>)ImmutableSet.copyOf(list));
    }

    private static class_1299<?> findEntityType(class_2960 name) {
        class_1299 type;
        if (class_7923.field_41177.method_10250(name) && (type = (class_1299)class_7923.field_41177.method_10223(name)) != null) {
            return type;
        }
        throw new JsonSyntaxException("Invalid entity type " + String.valueOf(name));
    }

    public static EntityIngredient deserialize(JsonElement root) {
        if (root.isJsonArray()) {
            JsonArray array = root.getAsJsonArray();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonElement element2 : array) {
                builder.add((Object)EntityIngredient.deserialize(element2));
            }
            return new Compound((List<EntityIngredient>)builder.build());
        }
        if (!root.isJsonObject()) {
            throw new JsonSyntaxException("Entity ingredient must be either an object or an array");
        }
        JsonObject json = root.getAsJsonObject();
        if (json.has("type")) {
            class_2960 name = new class_2960(class_3518.method_15265((JsonObject)json, (String)"type"));
            return new Single(EntityIngredient.findEntityType(name));
        }
        if (json.has("tag")) {
            return new TagMatch(class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)JsonHelper.getResourceLocation(json, "tag")));
        }
        if (json.has("types")) {
            List<class_1299> types = JsonHelper.parseList(json, "types", (element, key) -> EntityIngredient.findEntityType(new class_2960(class_3518.method_15287((JsonElement)element, (String)key))));
            return new SetMatch((Set<class_1299<?>>)ImmutableSet.copyOf(types));
        }
        throw new JsonSyntaxException("Invalid entity type ingredient, must have 'type', 'types', or 'tag'");
    }

    private static class Single
    extends EntityIngredient {
        private final class_1299<?> type;

        @Override
        public boolean test(class_1299<?> type) {
            return type == this.type;
        }

        public List<class_1299<?>> getTypes() {
            return Collections.singletonList(this.type);
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("type", Objects.requireNonNull(class_7923.field_41177.method_10221(this.type)).toString());
            return object;
        }

        public Single(class_1299<?> type) {
            this.type = type;
        }
    }

    private static class SetMatch
    extends EntityIngredient {
        private final Set<class_1299<?>> types;

        @Override
        public boolean test(class_1299<?> type) {
            return this.types.contains(type);
        }

        public Set<class_1299<?>> getTypes() {
            return this.types;
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            JsonArray array = new JsonArray();
            for (class_1299 type : this.getTypes()) {
                array.add(Objects.requireNonNull(class_7923.field_41177.method_10221((Object)type)).toString());
            }
            object.add("types", (JsonElement)array);
            return object;
        }

        public SetMatch(Set<class_1299<?>> types) {
            this.types = types;
        }
    }

    private static class TagMatch
    extends EntityIngredient {
        private final class_6862<class_1299<?>> tag;
        private List<class_1299<?>> types;

        @Override
        public boolean test(class_1299<?> type) {
            return type.method_20210(this.tag);
        }

        public List<class_1299<?>> getTypes() {
            if (this.types == null) {
                this.types = StreamSupport.stream(class_7923.field_41177.method_40286(this.tag).spliterator(), false).filter(class_6880::method_40227).map(class_6880::comp_349).collect(Collectors.toList());
            }
            return this.types;
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("tag", this.tag.comp_327().toString());
            return object;
        }

        public TagMatch(class_6862<class_1299<?>> tag) {
            this.tag = tag;
        }
    }

    private static class Compound
    extends EntityIngredient {
        private final List<EntityIngredient> ingredients;
        private List<class_1299<?>> allTypes;

        @Override
        public boolean test(class_1299<?> type) {
            for (EntityIngredient ingredient : this.ingredients) {
                if (!ingredient.test(type)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<class_1299<?>> getTypes() {
            if (this.allTypes == null) {
                this.allTypes = this.ingredients.stream().flatMap(ingredient -> ingredient.getTypes().stream()).distinct().collect(Collectors.toList());
            }
            return this.allTypes;
        }

        @Override
        public JsonElement serialize() {
            JsonArray array = new JsonArray();
            for (EntityIngredient ingredient : this.ingredients) {
                array.add(ingredient.serialize());
            }
            return array;
        }

        public Compound(List<EntityIngredient> ingredients) {
            this.ingredients = ingredients;
        }
    }
}

